/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.subtitles;

import club.sk1er.mods.subtitles.SubTitleMod;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiSubtitleOverlay
extends Gui {
    private final Minecraft client;
    private final List<Subtitle> subtitles = Lists.newArrayList();
    private final HashMap<String, String> soundMap = new HashMap();

    public GuiSubtitleOverlay(Minecraft clientIn) {
        this.client = clientIn;
        ResourceLocation mapped = new ResourceLocation("subtitles_mod", "data.json");
        try {
            JsonObject obj = new JsonParser().parse(this.read(clientIn.func_110442_L().func_110536_a(mapped).func_110527_b())).getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                this.soundMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Subtitle> getSubtitles() {
        return this.subtitles;
    }

    private String read(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public void renderSubtitles(ScaledResolution resolution) {
        if (SubTitleMod.showSubTitles && !this.subtitles.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            Vec3 Vec32 = new Vec3(this.client.field_71439_g.field_70165_t, this.client.field_71439_g.field_70163_u + (double)this.client.field_71439_g.func_70047_e(), this.client.field_71439_g.field_70161_v);
            Vec3 Vec31 = new Vec3(0.0, 0.0, -1.0).func_178789_a(-this.client.field_71439_g.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.client.field_71439_g.field_70177_z * ((float)Math.PI / 180));
            Vec3 Vec322 = new Vec3(0.0, 1.0, 0.0).func_178789_a(-this.client.field_71439_g.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.client.field_71439_g.field_70177_z * ((float)Math.PI / 180));
            Vec3 Vec33 = Vec31.func_72431_c(Vec322);
            int lineNumber = 0;
            int boxWidth = 0;
            Iterator<Subtitle> iterator = this.subtitles.iterator();
            while (iterator.hasNext()) {
                Subtitle guisubtitleoverlay$subtitle = iterator.next();
                if (guisubtitleoverlay$subtitle.getStartTime() + 3000L <= Minecraft.func_71386_F()) {
                    iterator.remove();
                    continue;
                }
                boxWidth = Math.max(boxWidth, this.client.field_71466_p.func_78256_a(guisubtitleoverlay$subtitle.getString()));
            }
            boxWidth = boxWidth + this.client.field_71466_p.func_78256_a("<") + this.client.field_71466_p.func_78256_a(" ") + this.client.field_71466_p.func_78256_a(">") + this.client.field_71466_p.func_78256_a(" ");
            int overFlowFac = 1;
            int underFlowFac = 0;
            for (Subtitle guisubtitleoverlay$subtitle1 : this.subtitles) {
                int k = 255;
                String s = guisubtitleoverlay$subtitle1.getString();
                Vec3 Vec34 = guisubtitleoverlay$subtitle1.getLocation().func_178788_d(Vec32).func_72432_b();
                double d0 = -Vec33.func_72430_b(Vec34);
                double d1 = -Vec31.func_72430_b(Vec34);
                boolean flag = d1 > 0.5;
                int halfBoxWidth = boxWidth / 2;
                int fontHeight = this.client.field_71466_p.field_78288_b;
                int halfFontHeight = fontHeight / 2;
                float scale = SubTitleMod.scale;
                int elementWidth = this.client.field_71466_p.func_78256_a(s);
                int l1 = MathHelper.func_76128_c((double)MathHelper.func_151238_b((double)255.0, (double)75.0, (double)((float)(Minecraft.func_71386_F() - guisubtitleoverlay$subtitle1.getStartTime()) / 3000.0f)));
                int i2 = l1 << 16 | l1 << 8 | l1;
                GlStateManager.func_179094_E();
                int x = SubTitleMod.x;
                int y = SubTitleMod.y;
                float xFac = (float)halfBoxWidth * scale - 2.0f;
                float yFac = (float)(lineNumber * (fontHeight + 1)) * scale + 10.0f;
                if ((float)(x + 2) + xFac > (float)resolution.func_78326_a()) {
                    x = (int)((float)(resolution.func_78326_a() - 2) - xFac);
                }
                if ((float)y + yFac + (float)halfFontHeight * scale > (float)resolution.func_78328_b()) {
                    y = (int)((float)y - (yFac - 10.0f));
                    y = (int)((float)y - (float)overFlowFac * scale * (float)(fontHeight + 1));
                    ++overFlowFac;
                }
                y = (int)((float)y + (float)underFlowFac * scale * (float)(fontHeight + 1));
                if ((float)x - (float)halfBoxWidth * scale < 0.0f) {
                    x = (int)((float)halfBoxWidth * scale);
                }
                if ((float)y + yFac - (float)halfFontHeight * scale < 0.0f) {
                    y = 10;
                    ++underFlowFac;
                }
                GlStateManager.func_179109_b((float)x, (float)((float)y + yFac), (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GuiSubtitleOverlay.func_73734_a((int)(-halfBoxWidth - 1), (int)(-halfFontHeight - 1), (int)(halfBoxWidth + 1), (int)(halfFontHeight + 1), (int)(SubTitleMod.alpha << 24));
                GlStateManager.func_179147_l();
                if (!flag) {
                    if (d0 > 0.0) {
                        this.client.field_71466_p.func_78276_b(">", halfBoxWidth - this.client.field_71466_p.func_78256_a(">"), -halfFontHeight, i2 + (k << 24 & 0xFF000000));
                    } else if (d0 < 0.0) {
                        this.client.field_71466_p.func_78276_b("<", -halfBoxWidth, -halfFontHeight, i2 + (k << 24 & 0xFF000000));
                    }
                }
                this.client.field_71466_p.func_78276_b(s, -elementWidth / 2, -halfFontHeight, i2 + (k << 24 & 0xFF000000));
                GlStateManager.func_179121_F();
                ++lineNumber;
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private String getName(ResourceLocation location) {
        return this.soundMap.get(location.func_110623_a());
    }

    public void soundPlay(ISound soundIn) {
        String s = this.getName(soundIn.func_147650_b());
        if (s == null) {
            if (SubTitleMod.showUnknownSounds) {
                s = soundIn.func_147650_b().func_110623_a();
            } else {
                return;
            }
        }
        if (s.isEmpty()) {
            return;
        }
        if (!this.subtitles.isEmpty()) {
            for (Subtitle guisubtitleoverlay$subtitle : this.subtitles) {
                if (!guisubtitleoverlay$subtitle.getString().equals(s)) continue;
                guisubtitleoverlay$subtitle.refresh(new Vec3((double)soundIn.func_147649_g(), (double)soundIn.func_147654_h(), (double)soundIn.func_147651_i()));
                return;
            }
        }
        this.subtitles.add(new Subtitle(s, new Vec3((double)soundIn.func_147649_g(), (double)soundIn.func_147654_h(), (double)soundIn.func_147651_i())));
    }

    public void addTempSignature() {
        int i = 0;
        for (Subtitle subtitle : this.subtitles) {
            if (!subtitle.subtitle.contains("Example Sound")) continue;
            subtitle.startTime = Minecraft.func_71386_F();
            ++i;
        }
        if (i < 2) {
            this.subtitles.add(new Subtitle("Example Sound " + (i + 1), new Vec3(0.0, 0.0, 0.0)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Subtitle {
        private final String subtitle;
        private long startTime;
        private Vec3 location;

        public Subtitle(String subtitleIn, Vec3 locationIn) {
            this.subtitle = subtitleIn;
            this.location = locationIn;
            this.startTime = Minecraft.func_71386_F();
        }

        public String getString() {
            return this.subtitle;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Vec3 getLocation() {
            return this.location;
        }

        public void refresh(Vec3 locationIn) {
            this.location = locationIn;
            this.startTime = Minecraft.func_71386_F();
        }
    }
}

